#include <windows.h>
#pragma hdrstop
#include <iostream>
#include <string>
#include <cstdlib>
#include <process.h>
#include "socket.h"

//---------------------------------------------------------------------------
// Global variables
std::string ServerAddress;
int ServerPort;

// Thread function
unsigned int __stdcall ProxyThread(void* param)
{
	// as is the socket which our server is listening to
	mlLib::Socket* as=reinterpret_cast<mlLib::Socket*>(param);
  bool connected=true;
  // Create a client socket to the remote server
  mlLib::TCPClient cs(ServerAddress,ServerPort);
  while(connected)
  {
    // Wait for data to be read
		if(cs.Readable())
    {
      do
      {
				char buffer[128];
	      // Read the data by chunk of 127 characters
				int nb=cs.Read(buffer,sizeof(buffer)-1);
	      as->Write(buffer,nb);
	      buffer[nb]=0x00;
	      std::cout<<buffer;
	      // recv yields 0 if the socket was closed by the peer
	      if(nb==0)connected=false;
      }
      // Repeat the socket read until there is no more character to be read.
      while(cs.BytesAvailable()>0);
    }
    if(as->Readable())
    {
	    do
	    {
			  char buffer[128];
	      int nb=as->Read(buffer,sizeof(buffer)-1);
	      cs.Write(buffer,nb);
	      buffer[nb]='\0';
	      std::cout<<buffer;
	      if(nb==0)connected=false;
     }
     while(as->BytesAvailable()>0);
    }
  }
  as->Close();
  cs.Close();
  delete as;
  return 0;
}

int main(int argc, char* argv[])
{
	if (argc != 4)
  {
  	std::cout<<"\nUsage:\n";
	  std::cout<<"\tproxy <port proxy> <addr server> <port server>\n"<<std::endl;
	  std::cout<<"\tAllows you to see the data exchanged by a client and a\n";
	  std::cout<<"\tserver.\n";
	  std::cout<<"\tFor instance: set your POP server to 'localhost' and the\n";
	  std::cout<<"\tPOP server port to '8888' then type:\n";
	  std::cout<<"\t\tproxy 8888 your.mail.server 110\n"<<std::endl;
  }
  else
  {
		int ProxyPort(std::atoi(argv[1]));
    ServerAddress=argv[2];
    ServerPort=std::atoi(argv[3]);
    try
    {
			mlLib::TCPServer ss(ProxyPort,10);
      while(true)
      {
				mlLib::Socket cs=ss.AcceptClient();
        mlLib::Socket *ts=new mlLib::Socket(cs);
        unsigned int id;
        _beginthreadex(NULL,0,ProxyThread,(void*)ts,0,&id);
      }
    }
    catch(mlLib::socket_exception& ex)
    {
      std::cout<<ex.what()<<std::endl;
    }
  }
  return 0;
}
 
